﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class CAct演奏チップファイア : CActivity
	{
		public void t発火( E演奏レーン eレーン, int nY座標補正値, bool bフィルイン = false, bool b大波 = false )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( eレーン == E演奏レーン.Unknown )
				return;
			//-----------------
			#endregion

			Point pt中心 = new Point();
			
			#region [ 火花の発火 ]
			//-----------------
			pt中心.X = Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X;
			pt中心.Y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + nY座標補正値;

			this.Act火花.t2D発火( pt中心 );
			//-----------------
			#endregion
			#region [ 拡散波の発火 ]
			//-----------------
			pt中心.X = Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X;
			pt中心.Y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + nY座標補正値;
			
			this.Act拡大波.t3D発火(
				new Vector3( pt中心.X, pt中心.Y, 0f ),	// 中心位置(2D座標)
				new Vector3( 0f, 0f, 1f ),	// 拡散波の法線
				0.1f, 1.5f,					// 最小倍率、最大倍率
				200,						// 所要時間[ms]
				0.21f );					// 最大不透明度(透明]:0～1:不透明)
			//-----------------
			#endregion
			#region [ 拡散粒子の発火 ]
			//-----------------
			pt中心.X = Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X;
			pt中心.Y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + nY座標補正値;

			this.Act拡散粒子.t2D発火( pt中心 );
			//-----------------
			#endregion

			if( bフィルイン )
			{
				// 未実装
			}
			if( b大波 )
			{
				// 未実装
			}
		}

		public CAct演奏チップファイア()
		{
			this.list子Activities.Add( this.Act火花 = new CMAct点フラッシュ・回転羽( 32 ) );
			this.list子Activities.Add( this.Act拡散粒子 = new CMAct点フラッシュ・拡散粒子( 32, 8 ) );
			this.list子Activities.Add( this.Act拡大波 = new CMAct点フラッシュ・拡大波( 32 ) );
		}

		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.tx羽 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay chip fire.png" ) );

			if( this.tx羽 != null )
				this.tx羽.b加算合成 = true;


			this.tx拡散粒子 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay chip star.png" ) );
			
			if( this.tx拡散粒子 != null )
				this.tx拡散粒子.b加算合成 = true;

	
			this.tx拡大波 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay chip wave2.png" ) );

			if( this.tx拡大波 != null )
				this.tx拡大波.b加算合成 = true;


			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.tx羽 );
			Global.tDisposeする( ref this.tx拡散粒子 );
			Global.tDisposeする( ref this.tx拡大波 );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;
			//-----------------
			#endregion

			this.Act火花.On進行();
			this.Act拡散粒子.On進行();
			this.Act拡大波.On進行();

			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.Act火花.On描画( hDevice, this.tx羽 );
			this.Act拡散粒子.On描画( hDevice, this.tx拡散粒子 );
			this.Act拡大波.On描画( hDevice, this.tx拡大波 );
		}

		CTexture tx羽 = null;
		CTexture tx拡散粒子 = null;
		CTexture tx拡大波 = null;
		CMAct点フラッシュ・回転羽 Act火花 = null;
		CMAct点フラッシュ・拡散粒子 Act拡散粒子 = null;
		CMAct点フラッシュ・拡大波 Act拡大波 = null;
	}
}
